import 'dart:convert';

import 'package:get/get.dart';
import 'package:get_storage/get_storage.dart';

import '../../common/models/child_model.dart';
import '../../features/auth/business_logic/auth_controller.dart';

class LocalStorage {
  final storage = GetStorage("test");
 static Future<void> init()async{
    await GetStorage.init("test");
  }

  Future<void> saveUserState(String userState) async {
    await storage.write('userState', userState);
  }

  Future<String> get getUserState async {
    return await storage.read('userState') ?? UserState.New.toString();
  }

  // Future<void> deleteUserState() async {
  //   await storage.remove('userState');
  // }

  Future<void> saveToken(String token) async {
    await storage.write('token', token);
  }

  String? get userToken {
  String? token =  storage.read('token');
  print(token);
  return token;
  }

  Future<void> saveFCMToken(var FCM) async {
   await storage.write('FCMToken', FCM);
  }

  String? get getFCMToken {
   String? FCMToken = storage.read('FCMToken');
   print('FCM: ${FCMToken}');
   return FCMToken;
  }

  Future<void> saveTypeUser(String typeUser) async {
    await storage.write('typeUser', typeUser);
  }

  String? get userTypeUser {
  String? typeUser =  storage.read('typeUser');
  print(typeUser);
  return typeUser;
  }

  // Future<void> deleteToken() async {
  //   await storage.remove('token');
  // }

  Future<void> saveUserPhoneNumber(String phoneNumber) async {
    await storage.write('phoneNumber', phoneNumber);
  }

  Future<String> get getUserPhoneNumber async {
    return await storage.read('phoneNumber');
  }

  // Future<void> deleteUserPhoneNumber() async {
  //   await storage.remove('phoneNumber');
  // }

  Future<void> saveUserChildren(List<ChildModel> children) async {
    await storage.write(
      'children',
      json.encode(
        {
          "children": ChildModel.toJsonList(children),
        },
      ),
    );
  }

  Future<List<ChildModel>> getUserChildren() async {
    String s = storage.read('children') ?? '';
    if (s.isEmpty) {
      return <ChildModel>[].obs;
    } else {
      Map<String, dynamic> myJson = json.decode(s);
      List<ChildModel> children = ChildModel.fromJsonList(
        myJson,
        'children',
      );
      print('s is $children');
      return children;
    }
  }

  // Future<void> deleteUserChildren() async {
  //   await storage.remove('children');
  // }

  Future<void> saveSelectedChild(int selectedChild) async {
    await storage.write("selectedChild", selectedChild);
  }

  Future<int> get readSelectedChild async {
    return await storage.read("selectedChild") ?? 0;
  }


  Future<void> delete() async {
    await storage.remove('userState');
    await storage.remove('token');
    await storage.remove('typeUser');
    await storage.remove('phoneNumber');
    await storage.remove('children');
    await storage.remove('selectedChild');
  }
}
